/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.platform.ClientServices;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VillagerBackpackLayer<T extends AbstractVillager, M extends VillagerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation WANDERING_BACKPACK = new ResourceLocation("backpacked", "wandering_bag");
    private final ItemStack displayStack = new ItemStack((ItemLike)ModItems.BACKPACK.get());
    private final ItemRenderer itemRenderer;

    public VillagerBackpackLayer(RenderLayerParent<T, M> renderer, ItemRenderer itemRenderer) {
        super(renderer);
        this.itemRenderer = itemRenderer;
    }

    public void render(PoseStack pose, MultiBufferSource source, int light, T villager, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        TraderPickpocketing.get(villager).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (villager.m_20145_()) {
                return;
            }
            Backpack backpack = BackpackManager.instance().getClientBackpack(WANDERING_BACKPACK);
            if (backpack == null) {
                return;
            }
            pose.m_85836_();
            pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            pose.m_85841_(1.0f, -1.0f, -1.0f);
            pose.m_85837_(0.0, -0.06, 0.21875);
            ModelMeta meta = BackpackManager.instance().getModelMeta(backpack);
            meta.renderer().ifPresentOrElse(renderer -> {
                pose.m_85836_();
                BackpackRenderContext context = new BackpackRenderContext(pose, source, light, this.displayStack, backpack, (LivingEntity)villager, partialTick, villager.f_19797_, model -> this.itemRenderer.m_115143_(this.displayStack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.f_118083_, model));
                renderer.forEach(function -> function.apply(context));
                pose.m_85849_();
            }, () -> {
                BakedModel model = ClientServices.MODEL.getBakedModel(backpack.getBaseModel());
                this.itemRenderer.m_115143_(this.displayStack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.f_118083_, model);
            });
            pose.m_85849_();
        });
    }

    private ModelPart getBody(VillagerModel<T> model) {
        return model.m_142109_().m_171324_("body");
    }
}

